﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            try
            {
                state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.RequestMessage.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Make Cancel Inbound ConnectToCrmStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}